                                                                     
/*
Program: MTUS_schema_W60_SAS.sas

Programmer: Aaron Lai, MTUS Research Centre

Date of Creation: 3/15/2009
Date of Modification: 3/25/2009

Purpose: Create the schema for the World 6.0 Version of MTUS

Remark: 

After running this program, it will create two SAS files 
in the SAS library mylib: frmschema60 and schema60.

The former one is a file that contains all the format definitions and they are 
created by proc format.

The latter one is a sample file that contains only one dummy record (the user need to 
delete that record before use) and all variables with appropriate formats applied.



*** Change the library (mylib) to your physical location/disk. ***

*** Note that the schema dataset contains one records with schema60='dummy' ***

Usage:

To use this program, please run it at least once so that the format and sample files are created.

Everytime you need to use the files without running this program, you need to execute the following
statement.

proc format cntlin = mylib.fmtschema60; run;

This statement will load the format into the memory.

For more programming detail on how to use, please refer to the conversion program.



*/                                                                     
                                                                     
libname mylib '________________________________';                                                                     
                                             
proc format cntlout = mylib.fmtschema60;                                                                 

value frmcountreg 
1 = 'Argentina'
2 = 'Austria'
3 = 'Australia'
4 = 'Belgium'
5 = 'Brazil'
6 = 'Bulgaria'
7 = 'Canada'
8 = 'China'
9 = 'Denmark'
10 = 'Estonia'
11 = 'Finland'
12 = 'France'
13 = 'Germany'
14 = 'Hungary'
15 = 'India'
16 = 'Ireland'
17 = 'Israel'
18 = 'Italy'
19 = 'Japan'
20 = 'Latvia'
21 = 'Lithuania'
22 = 'Netherlands'
23 = 'New Zealand'
24 = 'Norway'
25 = 'Peru'
26 = 'Poland'
27 = 'Portugal'
28 = 'Republic of Korea'
29 = 'Romania'
30 = 'Russia'
31 = 'Slovak Republic/Czechoslovakia'
32 = 'Slovenia/Yugoslavia'
33 = 'South Africa'
34 = 'Spain'
35 = 'Sweden'
36 = 'Turkey'
37 = 'United Kingdom'
38 = 'USA'
;

value frmcountry
1 = 'Canada'
2 = 'Denmark'
3 = 'France'
4 = 'Netherlands'
5 = 'Norway'
6 = 'UK'
7 = 'USA'
8 = 'Hungary'
9 = 'West Germany - now combined with 9, use MSAMP to distinguish'
10 = 'Poland'
11 = 'Belgium'
12 = 'Bulgaria'
13 = 'Czech - old code no longer in use, see Slovak Republic'
14 = 'East Germany - now combined with 9, use MSAMP to distinguish'
15 = 'Peru'
16 = 'Yugoslavia - old code no longer in use, see Slovenia'
17 = 'Finland'
18 = 'Italy'
19 = 'Australia'
20 = 'Israel'
21 = 'Sweden'
22 = 'Germany'
23 = 'Austria'
24 = 'South Africa'
25 = 'Brazil'
26 = 'Estonia'
27 = 'India'
28 = 'Japan'
31 = 'New Zealand'
32 = 'Portugal'
33 = 'Romania'
34 = 'Slovenia'
35 = 'Spain'
36 = 'Lituania'
37 = 'Latvia'
38 = 'Argentina'
39 = 'China'
40 = 'Ireland'
41 = 'Republic of Korea'
42 = 'Russia'
43 = 'Slovak Republic'
44 = 'Turkey'
;

value frmswave
0 = 'not longitudinal study/case'
1 = 'Wave 1'
2 = 'Wave 2'
3 = 'Wave 3'
4 = 'Wave 4'
;

value frmmsamp
0 = '1 sample'
1 = 'Szalai USA 65 sample'
2 = 'national USA 65 sample'
3 = 'original NHAPS'
4 = '95 NHAPS supplement'
5 = 'USA 85 mail back sample'
6 = 'USA 85 phone interview'
7 = 'USA 85 personal interview'
8 = 'Szalai Slovenia'
9 = 'Szalai Serbia'
10 = 'West Germany'
11 = 'East Germany'
;

value frmhldid
0 = '1 person sampled per household';

value frmparntid
-9 = 'could not be created'
-8 = 'could not identify parent in hh'
-7 = 'diarist does not live with parent'
;

value frmpartid
-9 = 'could not be created'
-8 = 'could not identify partner in hh'
-7 = 'diarist does not have partner'
;

value frmday
1 = 'Sunday'
2 = 'Monday'
3 = 'Tuesday'
4 = 'Wednesday'
5 = 'Thursday'
6 = 'Friday'
7 = 'Saturday'
8 = 'Whole week average'
9 = 'Unspecified weekday'
10 = 'Unspecified weekend day'
-8 = 'Missing'
-9 = 'could not be created'
;

value frmmonth
1 = 'January'
2 = 'February'
3 = 'March'
4 = 'April'
5 = 'May'
6 = 'June'
7 = 'July'
8 = 'August'
9 = 'September'
10 = 'October'
11 = 'November'
12 = 'December'
-8 = 'Missing'
-9 = 'could not be created'
;

value frmyear
-8 = 'Missing'
-9 = 'could not be created';

value frmdiary
1 = '1st diary day'
2 = '2nd diary day'
3 = '3rd diary day'
4 = '4th diary day'
5 = '5th diary day'
6 = '6th diary day'
7 = '7th diary day'
8 = 'Weekly average'
-8 = 'Missing'
-9 = 'could not be created';

value frmbadcase
0 = 'good case'
1 = 'miss age or sex only'
2 = 'miss day of week only'
3 = 'miss 91+ minutes only'
4 = '<7 episodes only'
5 = 'miss 2+ basic acts only'
6 = 'miss age/sex + day of week'
7 = 'miss age/sex + 91+ min'
8 = 'miss age/sex + <7 episodes'
9 = 'miss age/sex + 2+ basic acts'
10 = 'miss day of week + 91+ min'
11 = 'miss day of week + <7 episodes'
12 = 'miss day of week + 2+ basic acts'
13 = 'miss 91+ min + <7 episodes'
14 = 'miss 91+ min + 2+ basic acts'
15 = '<7 ep & miss 2+ basic acts'
16 = 'miss age/sex + day or week + 91+ min'
17 = 'miss age/sex + day or week + <7 episodes'
18 = 'miss age/sex + day or week + 2+ basic acts'
19 = 'miss age/sex + 91+ min + <7 eps'
20 = 'miss age/sex + 91+ min + 2+ basic acts'
21 = 'miss age/sex + 2+ basic acts + <7 eps'
22 = 'miss day or week + 91+ min + <7 eps'
23 = 'miss day or week + 91+ min + 2+ basic acts'
24 = 'miss day or week + 2+ basic acts + <7 eps'
25 = 'miss 91+ min + 2+ basic acts + <7 eps'
26 = 'miss age/sex + day or week + 91+ min + <7 episodes'
27 = 'miss age/sex + day or week + 91+ min + 2+ basic acts'
28 = 'miss age/sex + day or week + <7 episodes + 2+ basic acts'
29 = 'miss age/sex + 91+ min + <7 episodes + 2+ basic acts'
30 = 'day or week + 91+ min + <7 episodes + 2+ basic acts'
31 = 'bad on all five points'
;

value frmhhtype
1 = '1 person household'
2 = 'Married/cohabiting couple alone'
3 = 'Married/cohabiting couple + others'
4 = 'Other household types'
-7 = 'not applicable/not asked'
-8 = 'missing'
-9 = 'could not be created';

value frmgeneric
-7 = 'not applicable/not asked'
-8 = 'missing'
-9 = 'could not be created';

value frmage
1 = 'age 0-4'
2 = 'age 5-12'
3 = 'age 13-17'
4 = 'adult child'
-7 = 'not applicable/not asked'
-8 = 'missing'
-9 = 'could not be created'
80 = '80 or older'
;

value frmincome
1 = 'lowest 25%'
2 = 'middle 50%'
3 = 'highest 25%'
-7 = 'not applicable/not asked'
-8 = 'missing'
-9 = 'could not be created'
;

value frmownhome
1 = 'own outright or mortgage'
2 = 'rents'
3 = 'other'
-8 = 'missing'
-9 = 'could not be created'
;

value frmurban
1 = 'urban/suburban'
2 = 'rural/semi-rural'
-7 = 'not applicable/not asked'
-8 = 'missing'
-9 = 'could not be created'
;

value frmyesno
0 = 'no'
1 = 'yes'
-7 = 'not applicable/not asked'
-8 = 'missing'
-9 = 'could not be created'
;

value frmsex
1 = 'Man'
2 = 'Woman'
-8 = 'missing'
;

value frmage
80 = '80 or older'
-7 = 'not asked'
-8 = 'missing'
;

value frmfamstat
0 = 'Aged 18 to 39 with no coresident children <18'
1 = 'Aged 18+ living with 1+ coresident children aged <5'
2 = 'Aged 18+ living with 1+ coresident children 5-17, none <5'
3 = 'Aged 40+ with no coresident children <18'
4 = 'Aged <18 and living with parent(s)/guardian(s)'
5 = 'Aged <18, living arrangement other or unknown'
-7 = 'not applicable/not asked'
-8 = 'missing'
-9 = 'could not be created'
;

value frmrelrefp
1 = 'person 1'
2 = 'spouse/partner'
3 = 'child'
4 = 'parent'
5 = 'sibling'
6 = 'son/daughter-in-law'
7 = 'parent-in-law'
8 = 'brother/sister-in-law'
9 = 'other relative'
10 = 'not related'
-7 = 'not applicable/not asked'
-8 = 'missing'
-9 = 'could not be created'
;

value frmcivstat
1 = 'couple (married/cohabit/civ partnership)'
2 = 'not in couple'
-7 = 'not applicable/not asked'
-8 = 'missing'
-9 = 'could not be created'
;

value frmcohab
0 = 'no, married'
1 = 'yes, cohabitting'
-7 = 'not in couple'
-8 = 'missing'
-9 = 'could not be created'
;

value frmempstat
1 = 'full-time'
2 = 'part-time'
3 = 'unknown job hours'
4 = 'not in paid work'
-7 = 'not applicable/not asked'
-8 = 'missing'
-9 = 'could not be created'
;

value frmcphome
0 = 'not a child in parental home'
1 = 'child in parental home'
-7 = 'not applicable/not asked'
-8 = 'missing'
-9 = 'could not be created'
;

value frmemp
0 = 'not in paid work'
1 = 'in paid work'
-7 = 'not applicable/not asked'
-8 = 'missing'
-9 = 'could not be created'
;

value frmunemp
0 = 'not unemployed'
1 = 'unemployed'
-7 = 'not applicable/not asked'
-8 = 'missing'
-9 = 'could not be created'
;

value frmstudent
0 = 'not student'
1 = 'student'
-7 = 'not applicable/not asked'
-8 = 'missing'
-9 = 'could not be created'
;

value frmretired
0 = 'not retired'
1 = 'retired'
-7 = 'not applicable/not asked'
-8 = 'missing'
-9 = 'could not be created'
;

value frmempsp
1 = 'full-time'
2 = 'part-time'
3 = 'unknown job hours'
4 = 'not in paid work'
-7 = 'not applicable/not asked'
-8 = 'missing'
-9 = 'could not be created'
;

value frmoccup
1 = 'management'
2 = 'finance/legal profsnl'
3 = 'science/engineer profsnl'
4 = 'civil/social service prof'
5 = 'education professional'
6 = 'medical professional'
7 = 'other professional'
8 = 'health/educ/soc care support'
9 = 'clerical/office support'
10 = 'security/armed forces'
11 = 'sales/services/art support/clean'
12 = 'farm, forestry, fishing'
13 = 'construct, asmble/repair, transpt'
14 = 'self-employed non-professional'
-7 = 'not applicable/not asked'
-8 = 'missing'
-9 = 'could not be created'
;

value frmsector
1 = 'public sector'
2 = 'private sector'
-7 = 'not applicable/not asked'
-8 = 'missing'
-9 = 'could not be created'
;

value frmedtry
1 = 'inc 2ndry or less'
2 = 'completed secondary'
3 = 'above 2ndry education'
-7 = 'not applicable/not asked'
-8 = 'missing'
-9 = 'could not be created'
;

value frmrushed
0 = 'almost never'
1 = 'sometimes'
2 = 'often'
-7 = 'not applicable/not asked'
-8 = 'missing'
-9 = 'could not be created'
;

value frmhealth
0 = 'poor'
1 = 'fair'
2 = 'good'
3 = 'very good'
-7 = 'not applicable/not asked'
-8 = 'missing'
-9 = 'could not be created'
;

value frmmiss
-9 = 'could not be created'
other = _same_[d4.0]
;

value frmav
1 = 'paid work'
2 = 'paid work at home'
3 = 'second job'
4 = 'school/classes'
5 = 'travel to/from work'
6 = 'cook, wash up'
7 = 'housework'
8 = 'odd jobs'
9 = 'gardening'
10 = 'shopping'
11 = 'childcare'
12 = 'domestic travel'
13 = 'dress/personal care'
14 = 'consume services'
15 = 'meals, snacks'
16 = 'sleep'
17 = 'free time travel'
18 = 'excursions'
19 = 'active sport'
20 = 'passive sport'
21 = 'walks'
22 = 'religious activity'
23 = 'civic activity'
24 = 'cinema, theatre'
25 = 'dances, parties'
26 = 'social club'
27 = 'pub'
28 = 'restaurant'
29 = 'visit friends'
30 = 'listen to radio'
31 = 'TV, video'
32 = 'listen to CDs records'
33 = 'study'
34 = 'read books'
35 = 'read paper/magazine'
36 = 'relax'
37 = 'conversation'
38 = 'entertain friends'
39 = 'knit, sew'
40 = 'other leisure'
41 = 'missing'
;

value frmsec
-9 = 'no secondary activity in study'
-7 = 'no second act collected from diary group'
1 = 'imputed personal or household care'
2 = 'sleep and naps'
3 = 'imputed sleep'
4 = 'wash, dress, care for self'
5 = 'meals at work or school'
6 = 'other meals or snacks'
7 = 'paid work-main job (not at home)'
8 = 'paid work at home'
9 = 'second or other job not at home'
10 = 'unpaid work to generate household income'
11 = 'travel as a part of work'
12 = 'work breaks'
13 = 'other time at workplace'
14 = 'look for work'
15 = 'regular schooling, education'
16 = 'homework'
17 = 'leisure/other education or training'
18 = 'food preparation, cooking'
19 = 'set table, wash/put away dishes'
20 = 'cleaning'
21 = 'laundry, ironing, clothing repair'
22 = 'maintain home/vehicle'
23 = 'other domestic work'
24 = 'purchase goods'
25 = 'consume personal care services'
26 = 'consume other services'
27 = 'pet care (not walk dog)'
28 = 'physical, medical child care'
29 = 'teach, help with homework'
30 = 'read to, talk or play with child'
31 = 'supervise, accompany, other child care'
32 = 'adult care'
33 = 'voluntary, civic, organisational act'
34 = 'worship and religion'
35 = 'general out-of-home leisure'
36 = 'attend sporting event'
37 = 'cinema, theatre, opera, concert'
38 = 'other public event, venue'
39 = 'restaurant, caf, bar, pub'
40 = 'party, social event, gambling'
41 = 'imputed time away from home'
42 = 'general sport or exercise'
43 = 'walking'
44 = 'cycling'
45 = 'other outside recreation'
46 = 'gardening/pick mushrooms'
47 = 'walk dogs'
48 = 'receive or visit friends'
49 = 'conversation (in person, phone)'
50 = 'other in-home social, games'
51 = 'general indoor leisure'
52 = 'art or music'
53 = 'correspondence (not e-mail)'
54 = 'knit, crafts or hobbies'
55 = 'relax, think, do nothing'
56 = 'read'
57 = 'listen to music etc'
58 = 'listen to radio'
59 = 'watch TV, video, DVD'
60 = 'computer games'
61 = 'e-mail, surf internet, computing'
62 = 'no act but recorded transport mode'
63 = 'travel to/from work'
64 = 'education travel'
65 = 'voluntary/civic/religious travel'
66 = 'child/adult care travel'
67 = 'shop, person/hhld care travel'
68 = 'other travel'
69 = 'no recorded activity'
;

value frminout
-9 = 'location not collected by study'
-8 = 'location unknown'
-7 = 'location not collected from diary group'
1 = 'inside'
2 = 'outside'
3 = 'in vehicle'
;

value frmeloc
-9 = 'location not collected by study'
-8 = 'location unknown'
-7 = 'location not collected from diary group'
1 = 'at own home'
2 = 'at anothers home'
3 = 'at workplace'
4 = 'at school'
5 = 'at services or shops'
6 = 'at restaurant, bar etc'
7 = 'at place of worship'
8 = 'travelling'
9 = 'other locations'
;

value frmmtrav
-9 = 'mode not collected by study'
-8 = 'missing'
-7 = 'not travelling'
1 = 'travel by car etc'
2 = 'public transport'
3 = 'walk / on foot'
4 = 'other physical transport'
5 = 'other/unspecified transport'
;

value frmict
-9 = 'could not be created for study'
-7 = 'not collected for diary group'
0 = 'no'
1 = 'yes'
;

value frmvehicle
0 = 'no'
1 = 'animal only'
2 = 'non-motorised vehicle'
3 = '1 car/motorcycle'
4 = '2+ cars/motocycles'
-8 = 'missing'
-9 = 'could not be created'
;

value frmagekidx
1 = 'age 0-4'
2 = 'age 5-12'
3 = 'age 13-17'
4 = 'adult child'
-7 = 'not applicable/not asked'
-8 = 'missing'
-9 = 'could not be created'
;

value frmagekid
80 = '80 or older'
-7 = 'not applicable/not asked'
-8 = 'missing'
-9 = 'could not be created'
;

run;


data mylib.schema60;


label schema60 = 'Schema for World 6.0';

label countreg = 'Country or region of survey';
format countreg frmcountreg.;

label country = 'Old MTUS country of survey list';
format country frmcountry.;

label survey = 'Year survey began (survey id)';

label swave = 'longitudinal study wave marker';
format swave frmswave.;

label msamp = 'multiple samples in study';
format msamp frmmsamp.;

label hldid = 'Household identifier';
format hldid frmhldid.;

label persid = 'Person/diarist identifier';

label id = 'Diary identifier';

label parntid1 = 'Person id 1st parent of diarist';
format parntid1 frmparntid.;

label parntid2 = 'Person id 2nd parent of diarist';
format parntid2 frmparntid.;

label partid = 'Person id of spouse or partner';
format partid frmpartid.;

label day = 'Day of week diary kept';
format day frmday.;

label month = 'Month diary kept';
format month frmmonth.;

label  year = 'year diary kept';
format year frmyear.;

label diary = 'Diary order';
format diary frmdiary.;

label badcase = 'marker of low quality cases';
format badcase frmbadcase.;

label hhtype = 'Household type';
format hhtype frmhhtype.;

label hhldsize = '# people in household';
format hhldsize frmgeneric.;

label nchild = '# child aged<18 in hhold';
format nchild frmgeneric.;

label agekidx = 'Age youngest child in hhold (includes adult children)';
format agekidx frmagekidx.;

label agekid2 = 'Actual age youngest child in hhold';
format agekid2 frmagekid.;

label incorig = 'Original household income';

label income = 'Total hhold income grouped';
format income frmincome.;

label ownhome = 'owns or rents home';
format ownhome frmownhome.;

label urban = 'Urban or rural hhold';
format urban frmurban.;

label computer = 'hhold has computer/internet access';
format computer frmyesno.;

label vehicle = 'hhold access to a private vehicle';
format vehicle frmvehicle.;

label sex = 'Sex';
format sex frmsex.;

label age = 'Age';
format age frmage.;

label famstat = 'Individual level family status';
format famstat frmfamstat.;

label cphome = 'Unmarried child in parental home';
format cphome frmcphome.;

label singpar = 'diarist a single parent';
format singpar frmyesno.;

label relrefp = 'Relation to hhold ref person';
format relrefp frmrelrefp.;

label civstat = 'civic status';
format civstat frmcivstat.;

label cohab = 'diarist cohabiting';
format cohab frmcohab.;

label citizen = 'Diarist is citizen/national of country';
format citizen frmyesno.;

label empstat = 'employment status';
format empstat frmempstat.;

label emp = 'in paid work';
format emp frmemp.;

label unemp = 'unemployed';
format unemp frmunemp.;

label student = 'Student status';
format student frmstudent.;

label retired = 'Retirement status';
format retired frmretired.;

label empsp = 'Emp status spouse/partner';
format empsp frmempsp.;

label workhrs = 'Hours paid work last week inc overtime';
format workhrs frmgeneric.;

label empinclm = 'Orig monthly labour income';
format empinclm frmgeneric.;

label occup = 'Occupation';
format occup frmoccup.;

label sector = 'Sector of employment';
format sector frmsector.;

label educa = 'Education-original study codes';

label edtry = 'Harmonised education';
format edtry frmedtry.;

label rushed = 'Whether diarist ususally feels rushed';
format rushed frmrushed.;

label health = "Diarist's general health";
format health frmhealth.;

label carer = 'diarist provides adult care';

label disab = 'has disability/l-term hlth cond';
format disab frmyesno.;

label
AV1 = 'paid work'
AV2 = 'paid work at home'
AV3 = 'second job'
AV4 = 'school/classes'
AV5 = 'travel to/from work'
AV6 = 'cook, wash up'
AV7 = 'housework'
AV8 = 'odd jobs'
AV9 = 'gardening'
AV10 = 'shopping'
AV11 = 'childcare'
AV12 = 'domestic travel'
AV13 = 'dress/personal care'
AV14 = 'consume services'
AV15 = 'meals, snacks'
AV16 = 'sleep'
AV17 = 'free time travel'
AV18 = 'excursions'
AV19 = 'active sport'
AV20 = 'passive sport'
AV21 = 'walks'
AV22 = 'religious activity'
AV23 = 'civic activity'
AV24 = 'cinema, theatre'
AV25 = 'dances, parties'
AV26 = 'social club'
AV27 = 'pub'
AV28 = 'restaurant'
AV29 = 'visit friends'
AV30 = 'listen to radio'
AV31 = 'TV, video'
AV32 = 'listen to CDs records'
AV33 = 'study'
AV34 = 'read books'
AV35 = 'read paper/magazine'
AV36 = 'relax'
AV37 = 'conversation'
AV38 = 'entertain friends'
AV39 = 'knit, sew'
AV40 = 'other leisure'
AV41 = 'missing'

OCOMBWT = "BWT 'Original weight'"
PROPWT = "WT 'Proposed weight'"
;

format AV1 frmmiss.;
format AV2 frmmiss.;
format AV3 frmmiss.;
format AV4 frmmiss.;
format AV5 frmmiss.;
format AV6 frmmiss.;
format AV7 frmmiss.;
format AV8 frmmiss.;
format AV9 frmmiss.;
format AV10 frmmiss.;
format AV11 frmmiss.;
format AV12 frmmiss.;
format AV13 frmmiss.;
format AV14 frmmiss.;
format AV15 frmmiss.;
format AV16 frmmiss.;
format AV17 frmmiss.;
format AV18 frmmiss.;
format AV19 frmmiss.;
format AV20 frmmiss.;
format AV21 frmmiss.;
format AV22 frmmiss.;
format AV23 frmmiss.;
format AV24 frmmiss.;
format AV25 frmmiss.;
format AV26 frmmiss.;
format AV27 frmmiss.;
format AV28 frmmiss.;
format AV29 frmmiss.;
format AV30 frmmiss.;
format AV31 frmmiss.;
format AV32 frmmiss.;
format AV33 frmmiss.;
format AV34 frmmiss.;
format AV35 frmmiss.;
format AV36 frmmiss.;
format AV37 frmmiss.;
format AV38 frmmiss.;
format AV39 frmmiss.;
format AV40 frmmiss.;
format AV41 frmmiss.;

format OCOMBWT d6.2;
format PROPWT d6.2;

label main1 = 'imputed personal or household care';
label main2 = 'sleep and naps';
label main3 = 'imputed sleep';
label main4 = 'wash, dress, care for self';
label main5 = 'meals at work or school';
label main6 = 'other meals or snacks';
label main7 = 'paid work-main job (not at home)';
label main8 = 'paid work at home';
label main9 = 'second or other job not at home';
label main10 = 'unpaid work to generate household income';
label main11 = 'travel as a part of work';
label main12 = 'work breaks';
label main13 = 'other time at workplace';
label main14 = 'look for work';
label main15 = 'regular schooling, education';
label main16 = 'homework';
label main17 = 'leisure/other education or training';
label main18 = 'food preparation, cooking';
label main19 = 'set table, wash/put away dishes';
label main20 = 'cleaning';
label main21 = 'laundry, ironing, clothing repair';
label main22 = 'maintain home/vehicle';
label main23 = 'other domestic work';
label main24 = 'purchase goods';
label main25 = 'consume personal care services';
label main26 = 'consume other services';
label main27 = 'pet care (not walk dog)';
label main28 = 'physical, medical child care';
label main29 = 'teach, help with homework';
label main30 = 'read to, talk or play with child';
label main31 = 'supervise, accompany, other child care';
label main32 = 'adult care';
label main33 = 'voluntary, civic, organisational act';
label main34 = 'worship and religion';
label main35 = 'general out-of-home leisure';
label main36 = 'attend sporting event';
label main37 = 'cinema, theatre, opera, concert';
label main38 = 'other public event, venue';
label main39 = 'restaurant, caf, bar, pub';
label main40 = 'party, social event, gambling';
label main41 = 'imputed time away from home';
label main42 = 'general sport or exercise';
label main43 = 'walking';
label main44 = 'cycling';
label main45 = 'other outside recreation';
label main46 = 'gardening/pick mushrooms';
label main47 = 'walk dogs';
label main48 = 'receive or visit friends';
label main49 = 'conversation (in person, phone)';
label main50 = 'other in-home social, games';
label main51 = 'general indoor leisure';
label main52 = 'art or music';
label main53 = 'correspondence (not e-mail)';
label main54 = 'knit, crafts or hobbies';
label main55 = 'relax, think, do nothing';
label main56 = 'read';
label main57 = 'listen to music etc';
label main58 = 'listen to radio';
label main59 = 'watch TV, video, DVD';
label main60 = 'computer games';
label main61 = 'e-mail, surf internet, computing';
label main62 = 'no act but recorded transport mode';
label main63 = 'travel to/from work';
label main64 = 'education travel';
label main65 = 'voluntary/civic/religious travel';
label main66 = 'child/adult care travel';
label main67 = 'shop, person/hhld care travel';
label main68 = 'other travel';
label main69 = 'no recorded activity';

format main1 frmmiss.;
format main2 frmmiss.;
format main3 frmmiss.;
format main4 frmmiss.;
format main5 frmmiss.;
format main6 frmmiss.;
format main7 frmmiss.;
format main8 frmmiss.;
format main9 frmmiss.;
format main10 frmmiss.;
format main11 frmmiss.;
format main12 frmmiss.;
format main13 frmmiss.;
format main14 frmmiss.;
format main15 frmmiss.;
format main16 frmmiss.;
format main17 frmmiss.;
format main18 frmmiss.;
format main19 frmmiss.;
format main20 frmmiss.;
format main21 frmmiss.;
format main22 frmmiss.;
format main23 frmmiss.;
format main24 frmmiss.;
format main25 frmmiss.;
format main26 frmmiss.;
format main27 frmmiss.;
format main28 frmmiss.;
format main29 frmmiss.;
format main30 frmmiss.;
format main31 frmmiss.;
format main32 frmmiss.;
format main33 frmmiss.;
format main34 frmmiss.;
format main35 frmmiss.;
format main36 frmmiss.;
format main37 frmmiss.;
format main38 frmmiss.;
format main39 frmmiss.;
format main40 frmmiss.;
format main41 frmmiss.;
format main42 frmmiss.;
format main43 frmmiss.;
format main44 frmmiss.;
format main45 frmmiss.;
format main46 frmmiss.;
format main47 frmmiss.;
format main48 frmmiss.;
format main49 frmmiss.;
format main50 frmmiss.;
format main51 frmmiss.;
format main52 frmmiss.;
format main53 frmmiss.;
format main54 frmmiss.;
format main55 frmmiss.;
format main56 frmmiss.;
format main57 frmmiss.;
format main58 frmmiss.;
format main59 frmmiss.;
format main60 frmmiss.;
format main61 frmmiss.;
format main62 frmmiss.;
format main63 frmmiss.;
format main64 frmmiss.;
format main65 frmmiss.;
format main66 frmmiss.;
format main67 frmmiss.;
format main68 frmmiss.;
format main69 frmmiss.;

label sppart = 'time with spouse or partner';
format sppart frmmiss.;

label time = 'duration of activity in minutes';
label clockst = 'start time on 24 hour clock';
label start = 'start minute (of 1440 min 0=begin of diary)';
label end = 'end minute (of 1440 min 1440=end of diary)';
label epnum = 'episode number';

label main = 'main act, 69 category list';
label sec = 'secondary act, 69 category list';
label av = 'main act, old MTUS 41 category list';

format av frmav.;
format sec frmsec.;

label inout = 'inside or outside';
label eloc = 'location';
label mtrav = 'mode of transport';

format inout frminout.;
format eloc frmeloc.;
format mtrav frmmtrav.;

label ict = 'used ict during activity';
label alone = 'time alone or with strangers';
label child = 'child aged <18 present';
label sppart = 'spouse or partner present';
label oad = 'other adult present';

format ict frmict.;
format alone frmict.;
format child frmict.;
format sppart frmict.;
format oad frmict.;

format time d4.0;
format clockst d6.2;

label sppart = 'time with spouse or partner';
format sppart frmmiss.;

* set variables into missing;
survey = .;
persid = .;
id = .;
incorig = .;
educa = .;
carer = .;

* create a dummy row, can be deleted in production;
length schema60 $ 10.;
schema60 = 'dummy';

run;

proc contents data=mylib.schema60; 
title 'content Listing for World Schema 6.0';
run;
